<?php
use WHMCS\Database\Capsule;

if(isset($_REQUEST['invoiceId']) && is_numeric($_REQUEST['invoiceId']))
{
    require_once __DIR__ . '/../../init.php';
    require_once __DIR__ . '/../../includes/gatewayfunctions.php';
    require_once __DIR__ . '/../../includes/invoicefunctions.php';

    $gatewayParams = getGatewayVariables('systempanel');

    if(isset($_POST['PaymentStatus']) && isset($_POST['Authority']) && isset($_POST['InvoiceID']))
	{
        $invoice = Capsule::table('tblinvoices')->where('id', $_REQUEST['invoiceId'])->where('status', 'Unpaid')->first();

        if(!$invoice)
		{
            die("Invoice not found");
        }

        if ($_POST['PaymentStatus'] == 'OK')
		{
            $amount 	= ceil($invoice->total / ($gatewayParams['currencyType'] == 'IRT' ? 1 : 10));

			$Authority 	= (isset($_POST['Authority']) && $_POST['Authority'] != "") ? $_POST['Authority'] : "";
			$InvoiceID 	= (isset($_POST['InvoiceID']) && $_POST['InvoiceID'] != "") ? $_POST['InvoiceID'] : "";
			$MerchantID = ($gatewayParams['testMode'] == 'on') ? "sandbox" : $gatewayParams['MerchantID'];

			$result = systempanel_req("PaymentVerification", "MerchantID={$MerchantID}&Amount={$amount}&Authority={$Authority}");

            if ($result->Status == 100)
			{
                checkCbTransID($result->RefID);
                logTransaction($gatewayParams['name'], $_REQUEST, 'Success');

                addInvoicePayment(
                    $invoice->id,
                    $result->RefID,
                    $invoice->total,
                    0,
                    'systempanel'
                );
            } else {
                logTransaction($gatewayParams['name'], array(
                    'Code'        => 'systemPanel Status Code',
                    'Message'     => $result->Status,
                    'Transaction' => $_GET['Authority'],
                    'Invoice'     => $invoice->id,
                    'Amount'      => $invoice->total,
                ), 'Failure');
            }
        }

		$SystemURL 	= (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}";
		$SystemURL 	= str_replace("\\", "/", $SystemURL);
		$SystemURL 	= substr($SystemURL, 0, strpos($SystemURL, "modules/gateways"));
		$SystemURL 	= rtrim($SystemURL, "/");
		$SystemURL 	= (isset($gatewayParams['systemurl']) && $gatewayParams['systemurl'] != "") ? $gatewayParams['systemurl'] : $SystemURL;
		$SystemURL 	= "{$SystemURL}/viewinvoice.php?id={$invoice->id}";

        @header("Location: {$SystemURL}");

    } else if(isset($_SESSION['uid'])){

		$invoice = Capsule::table('tblinvoices')->where('id', $_REQUEST['invoiceId'])->where('status', 'Unpaid')->where('userid', $_SESSION['uid'])->first();

        if(!$invoice)
		{
            die("Invoice not found");
        }

        $client = Capsule::table('tblclients')->where('id', $_SESSION['uid'])->first();
        $amount = ceil($invoice->total / ($gatewayParams['currencyType'] == 'IRT' ? 1 : 10));

		$MerchantID 	= ($gatewayParams['testMode'] == 'on') ? "sandbox" : $gatewayParams['MerchantID'];
		$Description 	= sprintf('پرداخت فاکتور #%s', $invoice->id);
		$Email 			= "";
		$Mobile 		= "";

		$CallbackURL 	= (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}";
		$CallbackURL 	= str_replace("\\", "/", $CallbackURL);
		$CallbackURL 	= substr($CallbackURL, 0, strpos($CallbackURL, "modules/gateways"));
		$CallbackURL 	= rtrim($CallbackURL, "/");
		$CallbackURL 	= (isset($gatewayParams['systemurl']) && $gatewayParams['systemurl'] != "") ? $gatewayParams['systemurl'] : $CallbackURL;
		$CallbackURL 	= "{$CallbackURL}/modules/gateways/systempanel.php?invoiceId={$invoice->id}";

		$result = systempanel_req("PaymentRequest", "MerchantID={$MerchantID}&Amount={$amount}&InvoiceID={$invoice->id}&Description={$Description}&Email={$Email}&Mobile={$Mobile}&CallbackURL=". urlencode($CallbackURL));

        if ($result->Status == 100)
		{
            @header('Location: '. $result->PaymentUrl);
        } else {
            echo 'اتصال به درگاه امکان پذیر نیست: ', $result->Status;
        }
    }

    return;
}

if (!defined('WHMCS'))
{
	die('This file cannot be accessed directly');
}

function systempanel_req($method, $data)
{
	$curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, "https://payment.systempanel.ir/webservice/rest/{$method}");
	curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
	curl_setopt($curl, CURLOPT_POSTFIELDS, "{$data}");
	curl_setopt($curl, CURLOPT_TIMEOUT, 30);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	$curl_exec = curl_exec($curl);
	curl_close($curl);

	$result = json_decode($curl_exec);

	return $result;
}

function systempanel_MetaData()
{
    return array(
        'DisplayName' => 'ماژول پرداخت آنلاین https://payment.systempanel.ir برای WHMCS',
        'APIVersion' => '1.0',
    );
}

function systempanel_config()
{
    return array(
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'الکتروپدیا',
        ),
        'currencyType' => array(
            'FriendlyName' => 'نوع ارز',
            'Type' => 'dropdown',
            'Options' => array(
                'IRR' => 'ریال',
                'IRT' => 'تومان',
            ),
        ),
        'MerchantID' => array(
            'FriendlyName' => 'مریجنت کد',
            'Type' => 'text',
            'Size' => '255',
            'Default' => '',
            'Description' => 'مریجنت کد دریافتی از سایت الکتروپدیا',
        ),
        'testMode' => array(
            'FriendlyName' => 'حالت تستی',
            'Type' => 'yesno',
            'Description' => 'برای فعال کردن حالت تستی تیک بزنید',
        ),
    );
}

function systempanel_link($params)
{
    $htmlOutput = '<form method="GET" action="modules/gateways/systempanel.php">';
    $htmlOutput .= '<input type="hidden" name="invoiceId" value="' . $params['invoiceid'] .'">';
    $htmlOutput .= '<input type="submit" value="' . $params['langpaynow'] . '" />';
    $htmlOutput .= '</form>';
    return $htmlOutput;
}
